<?php
include 'conexao.php';
session_start();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $turma_id      = (int)$_POST['turma_id'];
    $disciplina_id = (int)$_POST['disciplina_id'];
    $trimestre     = (int)$_POST['trimestre'];
    $ano_lectivo   = '2025/2026';  // ajustar conforme seu padrão fixo ou pegue de outro lugar

    if (!isset($_POST['aluno_id']) || !is_array($_POST['aluno_id'])) {
        die("Nenhum aluno encontrado.");
    }

    foreach ($_POST['aluno_id'] as $aluno_id) {
        $aluno_id = (int)$aluno_id;

        // Função para pegar valor float ou NULL
        function valNota($key, $id) {
            if (!isset($_POST[$key . '_' . $id])) return null;
            $v = trim($_POST[$key . '_' . $id]);
            return ($v === '') ? null : floatval($v);
        }

        $av1 = valNota('av1', $aluno_id);
        $av2 = valNota('av2', $aluno_id);
        $av3 = valNota('av3', $aluno_id);
        $npt = valNota('npt', $aluno_id);
        $mt  = valNota("mt$trimestre", $aluno_id);

        $neo = valNota('neo', $aluno_id);
        $nee = valNota('nee', $aluno_id);
        $mec = valNota('mec', $aluno_id);
        $mfd = valNota('mfd', $aluno_id);
        $mf  = valNota('mf', $aluno_id);

        // Verifica se já existe
        $sqlCheck = "SELECT id FROM notas 
                     WHERE aluno_id = ? AND disciplina_id = ? 
                       AND turma_id = ? AND trimestre = ? AND ano_lectivo = ?";
        $stmtCheck = $conn->prepare($sqlCheck);
        $stmtCheck->bind_param("iiiis", $aluno_id, $disciplina_id, $turma_id, $trimestre, $ano_lectivo);
        $stmtCheck->execute();
        $stmtCheck->store_result();

        if ($stmtCheck->num_rows > 0) {
            // UPDATE
            $sqlUpdate = "UPDATE notas SET 
                av1 = ?, av2 = ?, av3 = ?, 
                npt = ?, mt{$trimestre} = ?, 
                neo = ?, nee = ?, mec = ?, mfd = ?, mf = ?
                WHERE aluno_id = ? AND disciplina_id = ? 
                  AND turma_id = ? AND trimestre = ? AND ano_lectivo = ?";
            $stmt = $conn->prepare($sqlUpdate);
            $stmt->bind_param(
                "ddddddddddiiiis",
                $av1, $av2, $av3, $npt, $mt,
                $neo, $nee, $mec, $mfd, $mf,
                $aluno_id, $disciplina_id, $turma_id, $trimestre, $ano_lectivo
            );
            $stmt->execute();
            $stmt->close();
        } else {
            // INSERT
            $sqlInsert = "INSERT INTO notas 
                (aluno_id, disciplina_id, turma_id, ano_lectivo, trimestre, 
                 av1, av2, av3, npt, mt{$trimestre}, neo, nee, mec, mfd, mf)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sqlInsert);
            $stmt->bind_param(
                "iiiisdddddddddd",
                $aluno_id, $disciplina_id, $turma_id, $ano_lectivo, $trimestre,
                $av1, $av2, $av3, $npt, $mt,
                $neo, $nee, $mec, $mfd, $mf
            );
            $stmt->execute();
            $stmt->close();
        }
        $stmtCheck->close();
    }

    header("Location: lancar_notas.php?turma_id=$turma_id&disciplina_id=$disciplina_id&trimestre=$trimestre&msg=Notas salvas");
    exit;
}
?>
